﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace MyWebApplication.Algoritmy
{
	public partial class Sort : System.Web.UI.Page
	{
		protected override void OnInit(EventArgs e)
		{
			base.OnInit(e);

			#region Sample data
			// vytvoření sample-dat, ve kterých budeme hledat
			var list = new List<Guid>();
			var hashSet = new HashSet<Guid>();
			Guid[] sortedArray;
			foreach (var guid in Enumerable.Range(0, 10000).Select(g => Guid.NewGuid()))
			{
				list.Add(guid);
				hashSet.Add(guid);
			}
			sortedArray = list.ToArray();
			Array.Sort(sortedArray);

			// vytvoření sample-dat, které budeme hledat
			var rand = new Random();
			var hledane = Enumerable.Range(0, 50000).Select(g =>
			{
				if (rand.NextDouble() > 0.5)
					return Guid.NewGuid();      // půlku chceme nových, které ve zdrojových datech nejsou
				else
					return list[rand.Next(list.Count)];   // a půlku, co tam jsou
			}).ToList();
			#endregion

			#region List
			// hledání v List
			int found = 0;
			var sw1 = new System.Diagnostics.Stopwatch();
			sw1.Start();
			for (int i = 0; i < hledane.Count; i++)
			{
				if (list.Contains(hledane[i]))
					found++;
			}
			sw1.Stop();
			ListLb.Text = String.Format("nalezeno {0:n0}, čas {1:n0}", found, sw1.ElapsedTicks);
			#endregion

			#region BinarySearch
			// hledání binárním půlením v seřazeném poli
			found = 0;
			var sw2 = new System.Diagnostics.Stopwatch();
			sw2.Start();
			for (int i = 0; i < hledane.Count; i++)
			{
				if (Array.BinarySearch<Guid>(sortedArray, hledane[i]) >= 0)
					found++;
			}
			sw2.Stop();
			BinarySearchLb.Text = String.Format("nalezeno {0:n0}, čas {1:n0}", found, sw2.ElapsedTicks);
			#endregion

			#region HashSet
			// hledání v hash-tabulce
			found = 0;
			var sw3 = new System.Diagnostics.Stopwatch();
			sw3.Start();
			for (int i = 0; i < hledane.Count; i++)
			{
				if (hashSet.Contains(hledane[i]))
					found++;
			}
			sw3.Stop();
			HashSetLb.Text = String.Format("nalezeno {0:n0}, čas {1:n0}", found, sw3.ElapsedTicks);
			#endregion
		}
	}
}