using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Session
{
	public partial class Default : System.Web.UI.Page
	{
		protected void Page_Load(object sender, EventArgs e)
		{
			Session["Skin"] = "YellowPanorama";
			Session["Culture"] = Thread.CurrentThread.CurrentUICulture;
			Session["Photo"] = Photo.Unknown;
		}
	}

	public class Photo
	{
		byte[] imageData;
		string imageFormat;
		public int Width {get; private set;}
		public int Height { get; private set; }

		public static Photo Unknown
		{
			get
			{
				return new Photo()
				{
					imageData = Enumerable.Range(0, 120000).Select(i => (byte)(i % 256)).ToArray(), // fake 120kB
					imageFormat = "bmp",
					Width = 400,
					Height = 300
				};

			}
		}

	}
}